VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3885
   ClientLeft      =   2550
   ClientTop       =   1770
   ClientWidth     =   5685
   LinkTopic       =   "Form1"
   ScaleHeight     =   3885
   ScaleWidth      =   5685
   Begin VB.ComboBox DeviceNum 
      Height          =   315
      Left            =   2640
      TabIndex        =   4
      Text            =   "Device Number"
      Top             =   720
      Width           =   1455
   End
   Begin VB.ListBox List1 
      Height          =   1815
      Left            =   2640
      TabIndex        =   3
      Top             =   1560
      Width           =   1815
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Scan 8 AI channels"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1320
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   720
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   960
      Top             =   2520
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   240
      Top             =   2520
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label3 
      Caption         =   "AI Channel Data:"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2640
      TabIndex        =   6
      Top             =   1320
      Width           =   975
   End
   Begin VB.Label Label2 
      Caption         =   "DriverLINX Device Number"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2640
      TabIndex        =   5
      Top             =   480
      Width           =   1935
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit ' require variable declaration

Private Sub cmdInit_Click()
' read in the device number we should use
Dim devNum As Integer
devNum = CInt(DeviceNum.Text)
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kmb1800" ' give driver name to avoid Open DriverLINX dialog; kmb1700 if DAS-1700 board
.Req_device = devNum
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
' error check
If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True   ' enable the scan button
' use of the LDD control is not required
' the LDD control can inform your application about the features of the hardware
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device  ' use same device number of the SR control
LDD.Refresh  ' load the LDD with data about the installed board
Form1.Caption = LDD.Dev_Model  'from the LDD, determine the model number
Else
' an error condition does exist...use message box operation to display error
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If

Form1.SetFocus  'set focus back to our form
End Sub

Private Sub cmdSample_Click()

SetupAIPaced
SR.Refresh  ' do it
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
' see Private Sub SR_BufferFilled() for what happens next
End Sub

Private Sub Form_Load()
' populate the combo box with legal DriverLINX device numbers 0..5
DeviceNum.AddItem "0", 0
DeviceNum.AddItem "1", 1
DeviceNum.AddItem "2", 2
DeviceNum.AddItem "3", 3
DeviceNum.AddItem "4", 4
DeviceNum.AddItem "5", 5
DeviceNum.ListIndex = 0  ' set the combo box equal to the first entry
End Sub

Private Sub Form_Terminate()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupAIPaced()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_INTERRUPT  ' could be DL_DMA if board has DMA feature
.Req_subsystem = DL_AI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically when buffer is filled
.Evt_Tim_type = DL_RATEEVENT ' timing will be used
.Evt_Tim_rateChannel = DL_DEFAULTTIMER  ' each board has default timing channel
.Evt_Tim_rateClock = DL_INTERNAL1       ' internal1 timebase (5MHz)
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_RATEGEN     ' one sample for each tic of clock
.Evt_Tim_rateOnCount = 0   ' not used for RATEGEN
.Evt_Tim_rateOutput = CT_Output_Default ' not used for RATEGEN
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 1000) ' 1000 Hz rate
.Evt_Tim_ratePulses = 0  ' not used for RATEGEN
' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 2                ' a start channel and stop channel
.Sel_chan_start = 0            ' start on channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' negative = bipolar, 1 = gain of 1
.Sel_chan_stop = 7
.Sel_chan_stopGainCode = .DLGain2Code(-1) 'stop on channel 7
' allocate one buffer of 8 samples for the data
.Sel_buf_N = 1                 ' one buffer used
.Sel_buf_samples = 8           ' big enough for one sample from each channel
' the buffer MUST be a multiple of how many channels are in the scan, e.g., 8, 16, 32 etc.
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
End With
End Sub


Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)

' allocate array for the data and some other variables that will be needed
Dim AIData(8) As Single  ' still hard coding size of the array/buffers
Dim dummy As Single
Dim i As Integer
List1.Clear  ' clear the list box

' the BufferFilled message contains the bufIndex that is ready for conversion
dummy = SR.VBArrayBufferConvert(bufIndex, 0, 8, AIData, DL_tSINGLE, 0, 0)
For i = 0 To 7
List1.AddItem "chan #: " & Str(i) & "  " & Str(Format(AIData(i), "###.##0"))
Next i
End Sub
